<?php

    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    $parametri = array("tabella"=>"geecEc_prodotti", "elementiPerPagina"=>10,"parametriRicerca"=>array(),"ajax"=>false);
    $ricercaProdotti = new Ricerca($geecomDb, $parametri, $impostazioniRicerca, "");
    $ricercaProdotti->setOrdinamento("ORDER BY numeroVisite DESC");
?>

    <div class="<?= $impostazioni["classeElementiStatisticiPerRigaHomeAdmin"] ?>">
        <div class="card mb-4 accordion box-shadow-lite">
            <div class="card-header collapsed" data-toggle="collapse" href="#articoliPiuLetti">
                <a class="card-title">
                    Prodotti più visti
                </a>
            </div>
            <div id="articoliPiuLetti" class="collapse show">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr class="d-flex">
                                    <th scope="col" class="col-1">#</th>
                                    <th scope="col" class="col-7 col-lg-8 col-xl-9">Nome</th>
                                    <th scope="col" class="col-4 col-lg-3 col-xl-2">Visite</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                    $risArticoli = $ricercaProdotti->eseguiRicerca(1);
                                    while($prodotto = $risArticoli->fetch_assoc()) {
                                        echo"<tr class=\"d-flex\">
                                            <td class=\"col-1 text-nowra\">{$prodotto["id"]}</th>
                                            <td class=\"col-7 col-lg-8 col-xl-9\"><a href=\"componenti/ecommerce/creaProdotto.php?id={$prodotto["id"]}\">{$prodotto["nome"]} </a></td>
                                            <td class=\"col-4 col-lg-3 col-xl-2\"><span class=\"badge badge-light\">{$prodotto["numeroVisite"]}</span></td>
                                        </tr>";
                                    }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="<?= $impostazioni["classeElementiStatisticiPerRigaHomeAdmin"] ?>">
        <div class="card mb-4 accordion box-shadow-lite">
            <div class="card-header collapsed" data-toggle="collapse" href="#articoliPiuVenduti">
                <a class="card-title">
                    Prodotti più venduti
                </a>
            </div>
            <div id="articoliPiuVenduti" class="collapse show">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr class="d-flex">
                                    <th scope="col" class="col-1">#</th>
                                    <th scope="col" class="col-7 col-lg-8 col-xl-9">Nome</th>
                                    <th scope="col" class="col-4 col-lg-3 col-xl-2">Vendite</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                    $parametri = array("tabella"=>"geecEc_prodotti", "elementiPerPagina"=>10,"parametriRicerca"=>array(),"ajax"=>false);
                                    $ricercaProdotti = new Ricerca($geecomDb, $parametri, $impostazioniRicerca, "");
                                    $ricercaProdotti->setOrdinamento("ORDER BY numeroVendite DESC");
                                    $risArticoli = $ricercaProdotti->eseguiRicerca(1);
                                    while($prodotto = $risArticoli->fetch_assoc()) {
                                        echo"<tr class=\"d-flex\">
                                            <td class=\"col-1 text-nowrap\">{$prodotto["id"]}</th>
                                            <td class=\"col-7 col-lg-8 col-xl-9\"><a href=\"componenti/ecommerce/creaProdotto.php?id={$prodotto["id"]}\">{$prodotto["nome"]} </a></td>
                                            <td class=\"col-4 col-lg-3 col-xl-2\"><span class=\"badge badge-light\">{$prodotto["numeroVendite"]}</span></td>
                                        </tr>";
                                    }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>